dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 5, 230, 480, "assets/images/table/castle_6", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 2, 3, 260, 220, "assets/images/table/castle", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 3, 4, 230, 350, "assets/images/table/castle", "assets/images/food/item_mark4", "R" );

useFloAsServer = 0;

useWineTable = 1;
numMoodBoosts = 3;
maxCoupleHappiness = 500;

--Level 5.4

--Group 1
guest = LManager.GenGuest(male02);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 2, 3000);

--Group 2
guest = LManager.GenGuest(aunt);
guest.matchType = table2;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestCoffee = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(3, 4, 12000);
--Original 6k

--Group 3
guest = LManager.GenGuest(male01);
guest.matchType = female01;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.likes={aunt};
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 6, 22000);

--Group 4
guest = LManager.GenGuest(male04);
guest.matchType = female04;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male02;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 32000);

--Group 5
guest = LManager.GenGuest(female03);
guest.matchType = male01;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female01;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 13, 65000);


--Group 6
guest = LManager.GenGuest(male03);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = aunt;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female01;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 17, 90000);


--Group 7
guest = LManager.GenGuest(uncle);
guest.matchType = table2;
guest.percentRequestCoffee = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.likes={male03};
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 21, 140000);


--Group 8
guest = LManager.GenGuest(aunt);
guest.likes={female03};
guest.matchType = male04;
guest.percentRequestTissue = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female01;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.likes={male03};
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.likes={male03};
guest.matchType = male01;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(22, 27, 180000);


--Group 9
guest = LManager.GenGuest(male03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + male01;
guest.percentRequestCoffee = 100;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(28, 30, 250000);


LManager:AdjustGuestTolerance(140);

LManager:SetLevelSetting ("cakeTipDelay", 30000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("dogDelay", 90000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("speakerDelay", 200000);
LManager:SetLevelSetting ("speakerChance", 20);

LManager:AddReseatingRequestForGuest(46000, female01);
LManager:AddReseatingRequestForGuest(220000, male04);
LManager:AddReseatingRequestForGuest(280000, aunt);

-- Set up the Level Settings
LManager:SetLevelNumber(5,4);
LManager:SetLevelScores(14000, 17000);
LManager:SetLevelTime(500000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/new_dance_1.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );